/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.shared;

import com.charliemouse.cambozola.shared.ResizableByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Hashtable;

public class StreamSplit {
    public static final String BOUNDARY_MARKER_PREFIX = "--";
    public static final String BOUNDARY_MARKER_TERM = "--";
    protected DataInputStream m_dis;
    private boolean m_streamEnd;

    public StreamSplit(DataInputStream dis) {
        this.m_dis = dis;
        this.m_streamEnd = false;
    }

    public Hashtable readHeaders() throws IOException {
        Hashtable ht = new Hashtable();
        boolean satisfied = false;
        while (true) {
            String response;
            if ((response = this.m_dis.readLine()) == null) {
                this.m_streamEnd = true;
                break;
            }
            if (response.equals("")) {
                if (satisfied) {
                    break;
                }
            } else {
                satisfied = true;
            }
            StreamSplit.addPropValue(response, ht);
        }
        return ht;
    }

    protected static void addPropValue(String response, Hashtable ht) {
        int idx = response.indexOf(":");
        if (idx == -1) {
            return;
        }
        String tag = response.substring(0, idx);
        String val = response.substring(idx + 1).trim();
        ht.put(tag.toLowerCase(), val);
    }

    public static Hashtable readHeaders(URLConnection conn) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        int i = 0;
        while (true) {
            String key;
            if ((key = conn.getHeaderFieldKey(i)) == null) {
                if (i != 0) break;
                ++i;
                continue;
            }
            String val = conn.getHeaderField(i);
            ht.put(key.toLowerCase(), val);
            ++i;
        }
        return ht;
    }

    public void skipToBoundary(String boundary) throws IOException {
        this.readToBoundary(boundary);
    }

    public byte[] readToBoundary(String boundary) throws IOException {
        ResizableByteArrayOutputStream baos = new ResizableByteArrayOutputStream();
        StringBuffer lastLine = new StringBuffer();
        int lineidx = 0;
        int chidx = 0;
        while (true) {
            byte ch;
            try {
                ch = this.m_dis.readByte();
            }
            catch (EOFException e) {
                this.m_streamEnd = true;
                break;
            }
            if (ch == 10 || ch == 13) {
                String lls = lastLine.toString();
                int idx = lls.indexOf("--");
                if (idx != -1 && (lls = lastLine.substring(idx)).startsWith(boundary)) {
                    String btest = lls.substring(boundary.length());
                    if (btest.equals("--")) {
                        this.m_streamEnd = true;
                    }
                    chidx = lineidx + idx;
                    break;
                }
                lastLine = new StringBuffer();
                lineidx = chidx + 1;
            } else {
                lastLine.append((char)ch);
            }
            ++chidx;
            baos.write(ch);
        }
        baos.close();
        baos.resize(chidx);
        return baos.toByteArray();
    }

    public boolean isAtStreamEnd() {
        return this.m_streamEnd;
    }
}

