/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.profiles;

import com.charliemouse.cambozola.PercentArea;
import com.charliemouse.cambozola.ViewerAttributeInterface;
import com.charliemouse.cambozola.profiles.Profile_NonInteractive;

public class Profile_LocalPTZ
extends Profile_NonInteractive {
    public Profile_LocalPTZ(ViewerAttributeInterface vai) {
        super(vai);
    }

    public String getDescription() {
        return "Client-side PanTiltZoom";
    }

    public boolean supportsPan() {
        return true;
    }

    public boolean supportsTilt() {
        return true;
    }

    public boolean supportsZoom() {
        return true;
    }

    public boolean supportsFocus() {
        return false;
    }

    public boolean supportsBrightness() {
        return false;
    }

    public void panLeft() {
        if (this.supportsPan()) {
            this.getViewerAttributes().getViewArea().panHorizontal(-1);
        }
    }

    public void panRight() {
        if (this.supportsPan()) {
            this.getViewerAttributes().getViewArea().panHorizontal(1);
        }
    }

    public void tiltUp() {
        if (this.supportsTilt()) {
            this.getViewerAttributes().getViewArea().panVertical(-1);
        }
    }

    public void tiltDown() {
        if (this.supportsTilt()) {
            this.getViewerAttributes().getViewArea().panVertical(1);
        }
    }

    public void homeView() {
        ViewerAttributeInterface vfi = this.getViewerAttributes();
        vfi.getViewArea().reset();
        vfi.repaint();
    }

    public void zoomTele() {
        if (this.supportsZoom()) {
            ViewerAttributeInterface vfi = this.getViewerAttributes();
            vfi.getViewArea().zoomIn();
            vfi.repaint();
        }
    }

    public void zoomWide() {
        if (this.supportsZoom()) {
            ViewerAttributeInterface vfi = this.getViewerAttributes();
            vfi.getViewArea().zoomOut();
            vfi.repaint();
        }
    }

    public void mouseClicked(int w, int h, int x, int y, boolean doubleClick) {
        this.moveToCenter(w, h, x, y);
    }

    public void moveToCenter(int w, int h, int x, int y) {
        if (this.supportsPan() || this.supportsTilt()) {
            ViewerAttributeInterface vfi = this.getViewerAttributes();
            PercentArea pa = vfi.getViewArea();
            double newCentX = (double)x / (double)w * 100.0;
            double newCentY = (double)y / (double)h * 100.0;
            pa.setBoundsAspect(newCentX, newCentY, pa.getWidth(), pa.getHeight());
        }
    }
}

