/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.profiles;

import com.charliemouse.cambozola.ViewerAttributeInterface;
import com.charliemouse.cambozola.profiles.Profile_LocalPTZ;

public class Profile_Panasonic_BLC30
extends Profile_LocalPTZ {
    public Profile_Panasonic_BLC30(ViewerAttributeInterface vai) {
        super(vai);
    }

    public String getDescription() {
        return "Panasonic BLC30";
    }

    public boolean supportsPan() {
        return true;
    }

    public boolean supportsTilt() {
        return true;
    }

    public boolean supportsZoom() {
        return true;
    }

    public boolean supportsFocus() {
        return false;
    }

    public boolean supportsBrightness() {
        return false;
    }

    public void panLeft() {
        if (this.supportsPan()) {
            this.execute("/nphControlCamera?Direction=PanLeft");
        }
    }

    public void panRight() {
        if (this.supportsPan()) {
            this.execute("/nphControlCamera?Direction=PanRight");
        }
    }

    public void tiltUp() {
        if (this.supportsTilt()) {
            this.execute("/nphControlCamera?Direction=TiltUp");
        }
    }

    public void tiltDown() {
        if (this.supportsTilt()) {
            this.execute("/nphControlCamera?Direction=TiltDown");
        }
    }

    public void moveToCenter(int w, int h, int x, int y) {
        if (this.supportsPan() || this.supportsTilt()) {
            this.execute("/nphControlCamera?Direction=Direct&Width=" + w + "&Height=" + h + "&NewPosition.x=" + x + "&NewPosition.y=" + y);
        }
    }

    public void homeView() {
        super.homeView();
        this.execute("/nphControlCamera?Direction=HomePosition");
    }

    public void focusNear() {
    }

    public void focusFar() {
    }

    public void focusAuto() {
    }

    public void zoomTele() {
        if (this.supportsZoom()) {
            super.zoomTele();
        }
    }

    public void zoomWide() {
        if (this.supportsZoom()) {
            super.zoomWide();
        }
    }

    public void darker() {
    }

    public void brighter() {
    }

    public void standardBrightness() {
    }

    public void mouseClicked(int w, int h, int x, int y, boolean doubleClick) {
        this.moveToCenter(w, h, x, y);
    }
}

