/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola;

import com.charliemouse.cambozola.Accessory;
import com.charliemouse.cambozola.PercentArea;
import com.charliemouse.cambozola.ViewerAttributeInterface;
import com.charliemouse.cambozola.profiles.ICameraProfile;
import com.charliemouse.cambozola.profiles.Profile_LocalPTZ;
import com.charliemouse.cambozola.shared.AppID;
import com.charliemouse.cambozola.shared.CamStream;
import com.charliemouse.cambozola.shared.ExceptionReporter;
import com.charliemouse.cambozola.shared.ImageChangeEvent;
import com.charliemouse.cambozola.shared.ImageChangeListener;
import com.charliemouse.cambozola.watermark.Watermark;
import com.charliemouse.cambozola.watermark.WatermarkCollection;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Viewer
extends Applet
implements MouseListener,
MouseMotionListener,
KeyListener,
ImageChangeListener,
ExceptionReporter,
ViewerAttributeInterface {
    private static final int DEFAULT_WIDTH = 352;
    private static final int DEFAULT_HEIGHT = 300;
    private static final String PAR_FAILUREIMAGE = "failureimage";
    private static final String PAR_DELAY = "delay";
    private static final String PAR_RETRIES = "retries";
    private static final String PAR_URL = "url";
    private static final String PAR_ACCESSORIES = "accessories";
    private static final String PAR_WATERMARK = "watermark";
    private static final String PAR_ACCESSORYSTYLE = "accessorystyle";
    private static final String PAR_DEBUG = "debug";
    private static final String PAR_SHOW_COPYRIGHT = "showCopyright";
    private static final String PAR_BACKGROUND = "backgroundColor";
    private static final String PAR_TEXTCOLOR = "textColor";
    private static final String PAR_USERAGENT = "userAgent";
    private static final String PAR_PROFILE = "profile";
    private static final int IMG_TYPE = 1;
    private static final int VAL_STYLE_INDENT = 0;
    private static final int VAL_STYLE_OVERLAY = 1;
    private static final int VAL_STYLE_ALWAYSON = 2;
    private static boolean ms_standalone = false;
    private Properties m_parameters = null;
    private URL m_documentBase = null;
    private URL m_codeBase = null;
    private URL m_mainURL = null;
    private Vector m_alternateURLs = null;
    private CamStream m_imgStream = null;
    private String m_msg = null;
    private AppID m_props = null;
    private boolean m_displayAccessories = false;
    private int m_accessoryStyle = 0;
    private PercentArea m_area = new PercentArea();
    private Vector m_accessories = new Vector();
    private Image m_offscreenAccBar = null;
    private Image m_backingStore = null;
    private boolean m_readingStream = false;
    private int m_retryCount = 1;
    private int m_retryDelay = 1000;
    private Image m_failureImage = null;
    private boolean m_loadFailure = false;
    private Watermark m_wmHit = null;
    private WatermarkCollection m_wmCollection = null;
    private boolean m_debug = false;
    private int m_imgWidth = 0;
    private int m_imgHeight = 0;
    private boolean m_showCopyright = true;
    private Color m_backgroundColor = Color.white;
    private Color m_textColor = Color.black;
    private String m_userAgent = null;
    private ICameraProfile m_profile = null;
    static /* synthetic */ Class class$com$charliemouse$cambozola$ViewerAttributeInterface;

    public Viewer() {
        this.m_props = AppID.getAppID();
        this.m_alternateURLs = new Vector();
        this.m_parameters = new Properties();
        ((Hashtable)this.m_parameters).put(PAR_ACCESSORYSTYLE, "indent");
        this.m_wmCollection = new WatermarkCollection();
    }

    public void init() {
        Color textCol;
        String appurl;
        String debug;
        String delay;
        String mm;
        if (!ms_standalone) {
            this.m_documentBase = this.getDocumentBase();
            this.m_codeBase = this.getCodeBase();
        }
        this.m_props = AppID.getAppID();
        this.m_alternateURLs = new Vector();
        String wmarks = this.getParameterValue(PAR_WATERMARK);
        if (wmarks != null) {
            this.m_wmCollection.populate(wmarks, this.m_documentBase);
        }
        if ("false".equalsIgnoreCase(mm = this.getParameterValue(PAR_SHOW_COPYRIGHT))) {
            this.m_showCopyright = false;
        }
        String appMsg = this.m_props.getAppNameVersion() + " " + this.m_props.getCopyright();
        if (this.m_showCopyright) {
            this.setMessage(appMsg);
        }
        System.err.println("// " + appMsg);
        System.err.println("// Build date: " + this.m_props.getBuildDate());
        System.err.println("// Available from " + this.m_props.getLocURL());
        String fistr = this.getParameterValue(PAR_FAILUREIMAGE);
        if (fistr != null && !fistr.equals("")) {
            try {
                URL fiurl = new URL(this.m_documentBase, fistr);
                this.setFailureImageURL(fiurl);
            }
            catch (MalformedURLException mfe) {
                System.err.println("Unable to access URL for failure image -" + fistr);
            }
        }
        if ((delay = this.getParameterValue(PAR_DELAY)) != null && !delay.equals("")) {
            try {
                int di = Integer.parseInt(delay);
                this.setRetryDelay(di);
            }
            catch (Exception e) {
                System.err.println("Unable to set retry delay");
            }
        }
        this.m_debug = (debug = this.getParameterValue(PAR_DEBUG)) != null && debug.equalsIgnoreCase("true");
        String retries = this.getParameterValue(PAR_RETRIES);
        if (retries != null && !retries.equals("")) {
            try {
                int ri = Integer.parseInt(retries);
                this.setRetryCount(ri);
            }
            catch (Exception e) {
                System.err.println("Unable to set retry count");
            }
        }
        if ((appurl = this.getParameterValue(PAR_URL)) == null && !appurl.equals("")) {
            throw new IllegalArgumentException("Missing URL");
        }
        this.m_mainURL = null;
        StringTokenizer st = new StringTokenizer(appurl, "|");
        while (st.hasMoreTokens()) {
            try {
                URL alt = new URL(this.m_codeBase, st.nextToken());
                this.m_alternateURLs.addElement(alt);
                if (this.m_mainURL != null) continue;
                this.m_mainURL = alt;
            }
            catch (MalformedURLException mfe) {
                this.reportError(mfe);
            }
        }
        String userAgent = this.getParameterValue(PAR_USERAGENT);
        this.m_userAgent = userAgent != null && !userAgent.equals("") && !userAgent.equalsIgnoreCase("default") ? userAgent : this.m_props.getAppNameVersion() + "/Java " + System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String profile = this.getParameterValue(PAR_PROFILE);
        if (profile != null && !profile.equals("")) {
            try {
                Class<?> profClazz = Class.forName("com.charliemouse.cambozola.profiles.Profile_" + profile);
                Constructor<?> constr = profClazz.getConstructor(class$com$charliemouse$cambozola$ViewerAttributeInterface == null ? (class$com$charliemouse$cambozola$ViewerAttributeInterface = Viewer.class$("com.charliemouse.cambozola.ViewerAttributeInterface")) : class$com$charliemouse$cambozola$ViewerAttributeInterface);
                this.m_profile = (ICameraProfile)constr.newInstance(this);
            }
            catch (Exception e) {
                System.err.println("Failed to set camera profile - " + profile);
                e.printStackTrace();
            }
        }
        if (this.m_profile == null) {
            this.m_profile = new Profile_LocalPTZ(this);
        }
        System.err.println("// Using Camera profile: " + this.m_profile.getDescription());
        this.setCurrentURL(this.m_mainURL);
        this.setAlternateURLs(this.m_alternateURLs);
        Color bg = Viewer.parseColor(this.getParameterValue(PAR_BACKGROUND));
        if (bg != null) {
            this.setBackgroundColor(bg);
        }
        if ((textCol = Viewer.parseColor(this.getParameterValue(PAR_TEXTCOLOR))) != null) {
            this.setTextColor(textCol);
        }
        this.configureAccessories(this.getParameterValue(PAR_ACCESSORIES));
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void destroy() {
        this.stop();
    }

    public static void main(String[] args) {
        ms_standalone = true;
        Frame f = new Frame(AppID.getAppID().getAppName());
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        f.setLayout(new BorderLayout());
        Viewer cv = new Viewer();
        int width = 352;
        int height = 300;
        StringBuffer concatURL = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                int eqidx = arg.indexOf("=") + 1;
                if (arg.equals("-noaccessories")) {
                    ((Hashtable)cv.m_parameters).put(PAR_ACCESSORIES, "none");
                    continue;
                }
                if (arg.startsWith("-accessories=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_ACCESSORIES, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-retries=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_RETRIES, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-delay=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_DELAY, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-failureimage=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_FAILUREIMAGE, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-watermark=") || arg.startsWith("-watermarks=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_WATERMARK, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-accessorystyle=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_ACCESSORYSTYLE, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-width=")) {
                    width = Integer.parseInt(arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-height=")) {
                    height = Integer.parseInt(arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-debug")) {
                    ((Hashtable)cv.m_parameters).put(PAR_DEBUG, "true");
                    continue;
                }
                if (arg.startsWith("-showCopyright=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_SHOW_COPYRIGHT, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-backgroundColor=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_BACKGROUND, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-textColor=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_TEXTCOLOR, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-userAgent=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_USERAGENT, arg.substring(eqidx));
                    continue;
                }
                if (arg.startsWith("-profile=")) {
                    ((Hashtable)cv.m_parameters).put(PAR_PROFILE, arg.substring(eqidx));
                    continue;
                }
                Viewer.usage();
                System.exit(0);
                continue;
            }
            if (concatURL.length() != 0) {
                concatURL.append("|");
            }
            concatURL.append(arg.trim());
        }
        f.setSize(width, height);
        if (concatURL.length() == 0) {
            Viewer.usage();
            System.exit(0);
        }
        ((Hashtable)cv.m_parameters).put(PAR_URL, concatURL.toString());
        f.add("Center", cv);
        cv.init();
        f.setVisible(true);
        cv.start();
    }

    private String getHTMLParameterValue(String key) {
        String s = this.getParameter(key);
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getParameterValue(String key) {
        if (!ms_standalone) {
            return this.getHTMLParameterValue(key);
        }
        return this.m_parameters.getProperty(key, null);
    }

    void setFailureImageURL(URL fistr) {
        try {
            this.m_failureImage = this.createImage((ImageProducer)fistr.getContent());
            this.m_failureImage.getWidth(this);
        }
        catch (IOException ie) {
            System.err.println("Unable to access failure image contents - " + ie);
        }
    }

    void setRetryCount(int rc) {
        if (rc < 1) {
            return;
        }
        this.m_retryCount = rc;
    }

    void setRetryDelay(int delay) {
        if (delay < 0) {
            return;
        }
        this.m_retryDelay = delay;
    }

    private void configureAccessories(String acclist) {
        String as = this.getParameterValue(PAR_ACCESSORYSTYLE);
        if (as != null) {
            if (as.equalsIgnoreCase("indent")) {
                this.m_accessoryStyle = 0;
            } else if (as.equalsIgnoreCase("overlay")) {
                this.m_accessoryStyle = 1;
            } else if (as.equalsIgnoreCase("always")) {
                this.m_accessoryStyle = 2;
            }
        }
        if (acclist == null || acclist.equals("") || acclist.equalsIgnoreCase("default")) {
            acclist = "Home,ZoomOut,ZoomIn,Pan,ChangeStream,Info,WWWHelp";
        } else if (acclist.equalsIgnoreCase("none")) {
            acclist = "";
        }
        StringTokenizer st = new StringTokenizer(acclist, ", ");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            try {
                Class<?> accClazz = Class.forName("com.charliemouse.cambozola.accessories." + tok + "Accessory");
                Accessory acc = (Accessory)accClazz.newInstance();
                if (!acc.isEnabled(this.m_profile, this)) continue;
                acc.getIconImage();
                this.m_accessories.addElement(acc);
            }
            catch (Exception exc) {
                System.err.println("Unable to load accessory - " + tok);
                exc.printStackTrace();
            }
        }
    }

    public synchronized void reportError(Throwable t) {
        this.reportNote(t.getMessage());
        this.m_loadFailure = true;
        this.stop();
    }

    public synchronized void reportFailure(String s) {
        this.m_loadFailure = true;
        this.reportNote(s);
    }

    public synchronized void reportNote(String s) {
        System.err.println(s);
        this.setMessage(s);
        this.m_readingStream = false;
        this.repaint();
    }

    private synchronized void setMessage(String s) {
        this.m_msg = s;
    }

    public void start() {
    }

    public void stop() {
        if (this.m_imgStream != null) {
            this.m_imgStream.unhook();
            this.m_imgStream = null;
        }
        this.m_readingStream = false;
        Enumeration e = this.m_accessories.elements();
        while (e.hasMoreElements()) {
            ((Accessory)e.nextElement()).terminate();
        }
    }

    public void setCurrentURL(URL loc) {
        this.m_loadFailure = false;
        this.m_mainURL = loc;
        if (this.m_imgStream != null) {
            this.m_msg = "";
            this.m_imgStream.removeImageChangeListener(this);
            this.m_imgStream.unhook();
        }
        this.m_imgStream = new CamStream(this.m_mainURL, this.m_userAgent, this.m_documentBase, this.m_retryCount, this.m_retryDelay, this, this.m_debug);
        this.m_imgStream.addImageChangeListener(this);
        this.m_imgStream.start();
    }

    public void displayURL(URL url, String target) {
        if (ms_standalone) {
            return;
        }
        if (target == null) {
            this.getAppletContext().showDocument(url);
        } else {
            this.getAppletContext().showDocument(url, target);
        }
    }

    public Vector getAlternateURLs() {
        return this.m_alternateURLs;
    }

    public void setAlternateURLs(Vector v) {
        this.m_alternateURLs = v;
    }

    public void imageChanged(ImageChangeEvent ce) {
        this.update(this.getGraphics());
        this.getToolkit().sync();
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        Image img;
        if (g == null) {
            return;
        }
        Dimension d = this.getSize();
        if (this.m_backingStore == null || this.m_backingStore.getWidth(this) != d.width || this.m_backingStore.getHeight(this) != d.height) {
            this.m_backingStore = new BufferedImage(d.width, d.height, 1);
            this.m_wmCollection.recalculateLocations(d);
        }
        Graphics gg2 = this.m_backingStore.getGraphics();
        if (this.m_loadFailure && this.m_failureImage != null) {
            this.paintFrame(gg2, this.m_failureImage, d, null);
        } else if (!this.m_readingStream) {
            gg2.setPaintMode();
            gg2.setColor(this.m_backgroundColor);
            if (this.isDisplayingAccessories() && this.m_accessoryStyle == 0) {
                gg2.fillRect(30, 0, d.width, d.height);
            } else {
                gg2.fillRect(0, 0, d.width, d.height);
            }
            FontMetrics fm = gg2.getFontMetrics();
            if (this.m_msg != null) {
                int width = fm.stringWidth(this.m_msg);
                gg2.setColor(this.m_textColor);
                gg2.drawString(this.m_msg, (d.width - width) / 2, d.height / 2);
                gg2.setColor(this.m_backgroundColor);
            }
            this.paintAccessories(gg2);
        }
        if (this.m_imgStream != null && (img = this.m_imgStream.getCurrent()) != null) {
            this.m_loadFailure = false;
            this.m_readingStream = true;
            this.paintFrame(gg2, img, d, this.m_wmCollection);
        }
        g.drawImage(this.m_backingStore, 0, 0, null);
        gg2.dispose();
    }

    public void paintFrame(Graphics g, Image img, Dimension d, WatermarkCollection wmc) {
        int indent = 0;
        if (this.isDisplayingAccessories() && this.m_accessoryStyle == 0) {
            indent = 30;
        }
        this.m_imgWidth = img.getWidth(this);
        this.m_imgHeight = img.getHeight(this);
        if (this.m_imgWidth == -1 || this.m_imgHeight == -1) {
            return;
        }
        Rectangle imgarea = this.m_area.getArea(this.m_imgWidth, this.m_imgHeight);
        g.drawImage(img, indent, 0, d.width, d.height, imgarea.x, imgarea.y, imgarea.x + imgarea.width, imgarea.y + imgarea.height, this);
        if (wmc != null) {
            wmc.paint(g);
        }
        this.paintAccessories(g);
    }

    private void paintAccessories(Graphics g) {
        Dimension d = this.getSize();
        int asize = this.m_accessories.size();
        if (this.isDisplayingAccessories() && asize > 0) {
            if (this.m_offscreenAccBar == null) {
                this.m_offscreenAccBar = this.createImage(30, this.m_accessories.size() * 30);
                Graphics accessoryBar = this.m_offscreenAccBar.getGraphics();
                int idx = 0;
                Enumeration accEnum = this.m_accessories.elements();
                while (accEnum.hasMoreElements()) {
                    accessoryBar.setColor(Color.lightGray);
                    Accessory acc = (Accessory)accEnum.nextElement();
                    int yoffset = idx * 30;
                    accessoryBar.fill3DRect(0, yoffset, 30, 30, true);
                    accessoryBar.drawImage(acc.getIconImage(), 3, yoffset + 3, new ImageObserver(){

                        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                            return true;
                        }
                    });
                    ++idx;
                }
                accessoryBar.dispose();
            }
            g.drawImage(this.m_offscreenAccBar, 0, 0, null);
            if (this.m_accessoryStyle == 0) {
                int fluff = this.m_accessories.size() * 30;
                g.setColor(this.m_backgroundColor);
                g.fillRect(0, fluff, 30, d.height);
            }
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (!this.m_readingStream) {
            return;
        }
        if (ke.getKeyCode() == 36) {
            this.m_profile.homeView();
        } else if (ke.getKeyCode() == 33 && this.m_profile.supportsZoom()) {
            this.m_profile.zoomTele();
        } else if (ke.getKeyCode() == 34 && this.m_profile.supportsZoom()) {
            this.m_profile.zoomWide();
        } else if (ke.getKeyCode() == 37 && this.m_profile.supportsPan()) {
            this.m_profile.panLeft();
        } else if (ke.getKeyCode() == 39 && this.m_profile.supportsPan()) {
            this.m_profile.panRight();
        } else if (ke.getKeyCode() == 38 && this.m_profile.supportsTilt()) {
            this.m_profile.tiltUp();
        } else if (ke.getKeyCode() == 40 && this.m_profile.supportsTilt()) {
            this.m_profile.tiltDown();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
        if (this.isDisplayingAccessories()) {
            this.setDisplayingAccessories(false);
            this.repaint();
        }
    }

    public boolean isDisplayingAccessories() {
        return this.m_displayAccessories || this.m_accessoryStyle == 2;
    }

    public void setDisplayingAccessories(boolean b) {
        this.m_displayAccessories = b;
    }

    public void mouseClicked(final MouseEvent me) {
        if (!ms_standalone && !this.isDisplayingAccessories() && this.m_wmHit != null) {
            this.displayURL(this.m_wmHit.getURL(), null);
            return;
        }
        if (me.getX() >= 30) {
            if (this.m_imgWidth > 0 && this.m_imgHeight > 0) {
                double px = (double)me.getX() / (double)this.getWidth();
                double py = (double)me.getY() / (double)this.getHeight();
                Rectangle imgarea = this.m_area.getArea(this.m_imgWidth, this.m_imgHeight);
                final int imgx = (int)(imgarea.getX() + imgarea.getWidth() * px);
                final int imgy = (int)(imgarea.getY() + imgarea.getHeight() * py);
                Runnable tr = new Runnable(){

                    public void run() {
                        Viewer.this.getProfile().mouseClicked(Viewer.this.m_imgWidth, Viewer.this.m_imgHeight, imgx, imgy, me.getClickCount() > 1);
                    }
                };
                new Thread(tr).start();
            }
            return;
        }
        int idx = me.getY() / 30;
        if (idx < this.m_accessories.size()) {
            Point p = new Point(me.getX(), me.getY() - idx * 30);
            ((Accessory)this.m_accessories.elementAt(idx)).actionPerformed(p, this);
        }
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
        Watermark pwnew;
        boolean needRepaint = false;
        Point p = me.getPoint();
        boolean previously = this.isDisplayingAccessories();
        if (p.x < 30) {
            if (this.m_accessories.size() > 0) {
                String desc;
                this.setDisplayingAccessories(true);
                int idx = me.getY() / 30;
                String statusFeedback = "";
                if (idx < this.m_accessories.size() && (desc = ((Accessory)this.m_accessories.elementAt(idx)).getDescription()) != null) {
                    statusFeedback = desc;
                }
                this.showStatus(statusFeedback);
            }
        } else {
            this.setDisplayingAccessories(false);
        }
        if (!this.m_displayAccessories && !ms_standalone && (pwnew = this.m_wmCollection.isOverClickableWatermark(p)) != this.m_wmHit) {
            this.m_wmHit = pwnew;
            needRepaint = true;
            this.setCursor(this.m_wmHit != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        }
        if (this.isDisplayingAccessories() != previously) {
            needRepaint = true;
        }
        if (needRepaint) {
            this.repaint();
        }
    }

    public void showStatus(String s) {
        if (!ms_standalone) {
            super.showStatus(s);
        }
    }

    public PercentArea getViewArea() {
        return this.m_area;
    }

    public ICameraProfile getProfile() {
        return this.m_profile;
    }

    public CamStream getStream() {
        return this.m_imgStream;
    }

    public boolean isStandalone() {
        return ms_standalone;
    }

    public Vector getAccessories() {
        return this.m_accessories;
    }

    private static Color parseColor(String s) {
        if (s == null || !s.startsWith("#") && s.length() != 7) {
            return null;
        }
        int r = Integer.parseInt(s.substring(1, 3), 16);
        int g = Integer.parseInt(s.substring(3, 5), 16);
        int b = Integer.parseInt(s.substring(5, 7), 16);
        return new Color(r, g, b);
    }

    public void setBackgroundColor(Color col) {
        this.m_backgroundColor = col;
    }

    public void setTextColor(Color col) {
        this.m_textColor = col;
    }

    public static void usage() {
        System.err.println("Usage: WebCamURL [otherURLs] [-accessories=comma separated accessory list]");
        System.err.println("Current set of accessories are:");
        System.err.println(" o ZoomIn       - Zooms in to the image");
        System.err.println(" o ZoomOut      - Zooms out of the image");
        System.err.println(" o Home         - Shows all the image");
        System.err.println(" o Pan          - Pan around a zoomed-in image");
        System.err.println(" o ChangeStream - Swap to a different stream (if > 1 listed)");
        System.err.println(" o Info         - Displays information about the stream");
        System.err.println(" o WWWHelp      - Displays a web page showing help");
        System.err.println("");
        System.err.println(" -debug                      Write debug information");
        System.err.println(" -width={width}              Sets the width of the application");
        System.err.println(" -height={height}            Sets the height of the application");
        System.err.println(" -noaccessories              Will not display any accessories");
        System.err.println(" -accessories=none           Will not display any accessories");
        System.err.println(" -accessories=default        Will display the default set of accessories");
        System.err.println(" -accessorystyle={see below} Defines how the accessories will appear on top-left");
        System.err.println("   indent                      Will squeeze the image [default]");
        System.err.println("   overlay                     Will overlay the accessories onto the image");
        System.err.println("   always                      Always display the accessories (overlaid)");
        System.err.println(" -retries={num}              The number of retries (default = 1)");
        System.err.println(" -delay={num}                The number of milliseconds between retries");
        System.err.println(" -failureimage={url}         Image to display if failure to connect");
        System.err.println(" -backgroundColor=#RRGGBB    Background Color in hex - e.g. #FF0000 for red");
        System.err.println(" -textColor=#RRGGBB          Text Color in hex - e.g. #FFFFFF for white");
        System.err.println(" -userAgent={useragent}      Sets the user-agent string, which will be used in the HTTP-request (f.e. 'Mozilla/5.0'");
        System.err.println(" -profile={Camera Profile}   Choose profile for camera");
        System.err.println(" -watermark={see below}      List of watermarks, separated by '|'");
        System.err.println("   imageURL|corner|linkURL     Watermark information, separated by '|'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

